﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7.Class;

namespace Winfoot_7
{
    public partial class Menu : UserControl
    {
        public delegate void DItemClick(object sender, WinfootMenuItem menuItem);
        /// <summary>
        /// アイテムクリックに対するイベントハンドラ。
        /// </summary>
        public event DItemClick ItemClick;

        public Menu()
        {
            InitializeComponent();
        }

        public void SetMenuItems(List<IMenuItem> menuItems)
        {
            this.AutoScroll = false;
            //コントロールを削除
            this.Controls.Clear();

            //メニューのセット
            //イベントを独自に追加
            //画像と文字列で固定？

            //横幅の決定[高さは50pxで固定]
            int wide=this.Width;
            if(menuItems.Count*50>this.Height)
            {
                wide = this.Width - 17;
            }

            for (int i = 0; i < menuItems.Count;i++ )
            {
                MenuItemControl item = new MenuItemControl(menuItems[i]);
                item.ItemClick += new MenuItemControl.DItemClick(item_ItemClick);
                item.Size = new Size(wide, 50);
                item.Location=new Point(0,50*i);
                item.Anchor = AnchorStyles.Left | AnchorStyles.Top | AnchorStyles.Right;
                this.Controls.Add(item);
            }

            this.AutoScroll = true;
        }

        void item_ItemClick(object sender, WinfootMenuItem menuItem)
        {
            if(ItemClick!=null)
            {
                ItemClick(sender, menuItem);
            }
        }

        //アイテムがクリックされたときに通知

    }
}
